<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$settings = get_option( 'ecf7l_settings', array(
    'enable_logging'          => 1,
    'notify_assignee_email'   => 0,
    'whatsapp_enabled'        => 1,
    'whatsapp_default_number' => '',
    'whatsapp_forms'          => array(),
    'webhooks'                => array(),
) );

$settings = wp_parse_args( $settings, array(
    'enable_logging'          => 1,
    'notify_assignee_email'   => 0,
    'whatsapp_enabled'        => 1,
    'whatsapp_default_number' => '',
    'whatsapp_forms'          => array(),
    'webhooks'                => array(),
) );


$is_pro = ecf7l_is_pro();

// Guardar ajustes
if ( isset( $_POST['ecf7l_save_settings'] ) && check_admin_referer( 'ecf7l_save_settings' ) ) {
    $settings['enable_logging']          = isset( $_POST['enable_logging'] ) ? 1 : 0;
    $settings['notify_assignee_email']   = isset( $_POST['notify_assignee_email'] ) ? 1 : 0;
    $settings['whatsapp_enabled']        = isset( $_POST['whatsapp_enabled'] ) ? 1 : 0;
    $settings['whatsapp_default_number'] = isset( $_POST['whatsapp_default_number'] ) ? sanitize_text_field( wp_unslash( $_POST['whatsapp_default_number'] ) ) : '';

    // WhatsApp por formulario
    $whatsapp_forms = array();
    if ( ! empty( $_POST['form_id'] ) && is_array( $_POST['form_id'] ) ) {
        foreach ( $_POST['form_id'] as $index => $form_id ) {
            $form_id = (int) $form_id;
            if ( $form_id <= 0 ) {
                continue;
            }
            $enabled  = ! empty( $_POST['form_whatsapp_enabled'][ $index ] ) ? 1 : 0;
            $number   = isset( $_POST['form_whatsapp_number'][ $index ] ) ? sanitize_text_field( wp_unslash( $_POST['form_whatsapp_number'][ $index ] ) ) : '';
            $template = isset( $_POST['form_whatsapp_template'][ $index ] ) ? wp_kses_post( wp_unslash( $_POST['form_whatsapp_template'][ $index ] ) ) : '';

            $whatsapp_forms[ $form_id ] = array(
                'enabled'  => $enabled,
                'number'   => $number,
                'template' => $template,
            );
        }
    }
    $settings['whatsapp_forms'] = $whatsapp_forms;

    $webhooks = array();
    if ( ! empty( $_POST['wh_url'] ) && is_array( $_POST['wh_url'] ) ) {
        $wh_form_ids = isset( $_POST['wh_forms'] ) ? $_POST['wh_forms'] : array();
        foreach ( $_POST['wh_url'] as $index => $url ) {
            $url = trim( wp_unslash( $url ) );
            if ( '' === $url ) {
                continue;
            }
            $hook = array(
                'url'    => esc_url_raw( $url ),
                'active' => ! empty( $_POST['wh_active'][ $index ] ) ? 1 : 0,
                'forms'  => array(),
            );
            if ( isset( $wh_form_ids[ $index ] ) && is_array( $wh_form_ids[ $index ] ) ) {
                $hook['forms'] = array_map( 'intval', $wh_form_ids[ $index ] );
            }
            $webhooks[] = $hook;
        }
    }
    $settings['webhooks'] = $webhooks;

    update_option( 'ecf7l_settings', $settings );
    

    echo '<div class="ecf7l-notice ecf7l-notice-success">
        <div class="ecf7l-notice-icon">
            <!-- Success icon -->
            <svg viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" 
                    d="M16.707 5.293a1 1 0 010 1.414l-7.25 7.25a1 1 0 01-1.414 0l-3.5-3.5a1 1 0 011.414-1.414L8.5 11.086l6.543-6.543a1 1 0 011.414 0z" 
                    clip-rule="evenodd"/>
            </svg>
        </div>
        <div>'.esc_html( $message ).'</div>
    </div>';

}

// Licencia (simple, sin validación remota real)
if ( isset( $_POST['ecf7l_save_license'] ) && check_admin_referer( 'ecf7l_save_license' ) ) {
    $key = isset( $_POST['license_key'] ) ? sanitize_text_field( wp_unslash( $_POST['license_key'] ) ) : '';
    update_option( 'ecf7l_license_key', $key );
    // Aquí podrías hacer petición remota. Por ahora si no está vacío, la marcamos como válida.
    update_option( 'ecf7l_license_status', $key ? 'valid' : 'free' );
    echo '<div class="ecf7l-notice ecf7l-notice-success">
        <div class="ecf7l-notice-icon">
            <!-- Success icon -->
            <svg viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" 
                    d="M16.707 5.293a1 1 0 010 1.414l-7.25 7.25a1 1 0 01-1.414 0l-3.5-3.5a1 1 0 011.414-1.414L8.5 11.086l6.543-6.543a1 1 0 011.414 0z" 
                    clip-rule="evenodd"/>
            </svg>
        </div>
        <div>Licencia actualizada</div>
    </div>';
}

$whatsapp_forms = isset( $settings['whatsapp_forms'] ) ? $settings['whatsapp_forms'] : array();
$webhooks       = isset( $settings['webhooks'] ) ? $settings['webhooks'] : array();

// Formularios CF7
$cf7_forms = get_posts( array(
    'post_type'      => 'wpcf7_contact_form',
    'posts_per_page' => -1,
    'post_status'    => 'publish',
) );

$license_key    = get_option( 'ecf7l_license_key', '' );
$license_status = get_option( 'ecf7l_license_status', 'free' );
?>
<div class="wrap ecf7l-wrap">
    <div class="ecf7l-header">
        <div class="ecf7l-header-main">
        <div class="ecf7l-logo-badge">
            <?php
                echo '<img src="' . plugins_url( 'assets/images/icon-300x300-trasparent.png', dirname(__FILE__) ) . '" > ';
            ?>
        </div>
            <div>
                <h1 class="ecf7l-header-title">Ajustes</h1>
                <p class="ecf7l-header-subtitle">Activa o desactiva el guardado de leads y notificaciones, activa y personaliza el envío por whatsApp y Webhooks.</p>
            </div>
        </div>
        <div class="ecf7l-header-side">
            <div class="ecf7l-badge-pill">
                <span class="dot"></span>
                <span><?php echo ecf7l_is_pro() ? 'Licencia PRO activa' : 'Modo FREE'; ?></span>
            </div>
        </div>
    </div>

    <h2>General</h2>
    <form method="post">
        <?php wp_nonce_field( 'ecf7l_save_settings' ); ?>
        <table class="form-table">
            <tr>
                <th scope="row"><label for="enable_logging">Guardar leads en BD</label></th>
                <td>
                    <label>
                        <input type="checkbox" name="enable_logging" id="enable_logging" <?php checked( ! empty( $settings['enable_logging'] ) ); ?>>
                        Activar guardado de envíos (Free)
                    </label>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="notify_assignee_email">Email de alerta al asignar responsable</label></th>
                <td>
                    <label>
                        <input type="checkbox" name="notify_assignee_email" id="notify_assignee_email"
                            <?php checked( ! empty( $settings['notify_assignee_email'] ) ); ?>
                            <?php disabled( ! $is_pro ); ?>
                        >
                        Enviar email al usuario de WordPress cuando se le asigna un lead (PRO)
                    </label>
                    <?php if ( ! $is_pro ) : ?>
                        <p class="description">Disponible con licencia PRO.</p>
                    <?php else : ?>
                        <p class="description">Se enviará una notificación al correo del usuario asignado.</p>
                    <?php endif; ?>
                </td>
            </tr>
        </table>


        <h2>WhatsApp Redirect</h2>
        <table class="form-table">
            <tr>
                <th scope="row"><label for="whatsapp_enabled">Habilitar WhatsApp redirect</label></th>
                <td>
                    <label>
                        <input type="checkbox" name="whatsapp_enabled" id="whatsapp_enabled" <?php checked( ! empty( $settings['whatsapp_enabled'] ) ); ?>>
                        Activar integración de WhatsApp
                    </label>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="whatsapp_default_number">Número de WhatsApp por defecto</label></th>
                <td>
                    <input type="text" class="regular-text" name="whatsapp_default_number" id="whatsapp_default_number" value="<?php echo esc_attr( $settings['whatsapp_default_number'] ); ?>" placeholder="34600000000">
                    <p class="description">Formato internacional sin + (ej: 34600000000).</p>
                </td>
            </tr>
        </table>

        <h2>WhatsApp por formulario</h2>
        <p>Puedes personalizar número y mensaje de WhatsApp por cada formulario de CF7.</p>

        <table class="widefat fixed striped ecf7l-table">
            <thead>
                <tr>
                    <th>Formulario</th>
                    <th>Activar</th>
                    <th>Número</th>
                    <th>Mensaje (puedes usar tags tipo [your-name])</th>
                </tr>
            </thead>
            <tbody>
                <?php if ( empty( $cf7_forms ) ) : ?>
                    <tr><td colspan="4">No se han encontrado formularios de Contact Form 7.</td></tr>
                <?php else : ?>
                    <?php foreach ( $cf7_forms as $form ) :
                        $form_id = $form->ID;
                        $conf = isset( $whatsapp_forms[ $form_id ] ) ? $whatsapp_forms[ $form_id ] : array(
                            'enabled'  => 0,
                            'number'   => '',
                            'template' => 'Hola, soy [your-name] y acabo de enviar el formulario.',
                        );
                        ?>
                        <tr>
                            <td>
                                <?php echo esc_html( $form->post_title ); ?>
                                <input type="hidden" name="form_id[]" value="<?php echo (int) $form_id; ?>">
                            </td>
                            <td>
                                <input type="checkbox" name="form_whatsapp_enabled[]" <?php checked( ! empty( $conf['enabled'] ) ); ?>>
                            </td>
                            <td>
                                <input type="text" name="form_whatsapp_number[]" class="regular-text" value="<?php echo esc_attr( $conf['number'] ); ?>" placeholder="<?php echo esc_attr( $settings['whatsapp_default_number'] ); ?>">
                            </td>
                            <td>
                                <textarea name="form_whatsapp_template[]" rows="3" class="large-text"><?php echo esc_textarea( $conf['template'] ); ?></textarea>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>

        <h2>Webhooks (PRO)</h2>
        <p>Envía cada lead nuevo a un endpoint externo (por ejemplo, un script de Google Sheets, Zapier, Make, n8n...).</p>
        <?php if ( ! $is_pro ) : ?>
            <p><strong>Nota:</strong> Puedes configurar aquí los webhooks, pero solo se activarán cuando tu licencia esté en PRO.</p>
        <?php endif; ?>

        <table class="widefat fixed striped ecf7l-table">
            <thead>
                <tr>
                    <th>Activo</th>
                    <th>URL del webhook</th>
                    <th>Formularios (opcional)</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ( empty( $webhooks ) ) {
                    $webhooks[] = array( 'url' => '', 'active' => 0, 'forms' => array() );
                }
                foreach ( $webhooks as $index => $hook ) :
                    ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="wh_active[<?php echo (int) $index; ?>]" <?php checked( ! empty( $hook['active'] ) ); ?>>
                        </td>
                        <td>
                            <input type="text" name="wh_url[<?php echo (int) $index; ?>]" class="large-text" value="<?php echo esc_attr( $hook['url'] ); ?>" placeholder="https://...">
                        </td>
                        <td>
                            <select name="wh_forms[<?php echo (int) $index; ?>][]" multiple size="3" style="min-width:200px;">
                                <option value="">Todos</option>
                                <?php foreach ( $cf7_forms as $form ) : ?>
                                    <option value="<?php echo (int) $form->ID; ?>" <?php selected( in_array( $form->ID, $hook['forms'], true ), true ); ?>>
                                        <?php echo esc_html( $form->post_title ); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <p class="description">Déjalo vacío para todos los formularios.</p>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <p class="description">Para conectar con Google Sheets, crea un endpoint con Google Apps Script que reciba el JSON y lo inserte en una hoja.</p>

        <p class="submit">
            <button type="submit" name="ecf7l_save_settings" class="button button-primary">Guardar ajustes</button>
        </p>
    </form>

    <hr>
</div>


<?php include ECF7L_DIR . 'views/footer.php';  ?>