<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$is_pro = ecf7l_is_pro();

// Usuarios que pueden ser responsables
$users = get_users(
    array(
        'role__in' => array( 'administrator', 'editor', 'author' ),
        'orderby'  => 'display_name',
        'order'    => 'ASC',
    )
);

// --- Acciones masivas (POST) ---
if ( isset( $_POST['ecf7l_bulk_action'] ) && check_admin_referer( 'ecf7l_leads_bulk' ) ) {

    $bulk_action = sanitize_text_field( wp_unslash( $_POST['ecf7l_bulk_action'] ) );
    $ids         = isset( $_POST['lead_ids'] ) ? (array) $_POST['lead_ids'] : array();
    $ids         = array_filter( array_map( 'intval', $ids ) );

    if ( empty( $bulk_action ) || empty( $ids ) ) :
        ?>
        <div class="ecf7l-notice ecf7l-notice-warning">
            <div class="ecf7l-notice-icon">
                <svg viewBox="0 0 20 20" fill="currentColor">
                    <path d="M8.257 3.099c.765-1.36 2.721-1.36 3.486 0l6.518 11.602A2 2 0 0116.518 18H3.482a2 2 0 01-1.743-3.299L8.257 3.1zM9 7v4h2V7H9zm0 6v2h2v-2H9z"/>
                </svg>
            </div>
            <div><p><?php esc_html_e( 'No se han seleccionado leads ni acción.', 'easycf7-leads' ); ?></p></div>
        </div>
        <?php
    else :

        if ( 'delete' === $bulk_action ) {
            $deleted = 0;
            foreach ( $ids as $lead_id ) {
                if ( class_exists( 'ECF7L_Notes' ) ) {
                    ECF7L_Notes::delete_for_lead( $lead_id );
                }
                if ( ECF7L_Leads::delete( $lead_id ) ) {
                    $deleted++;
                }
            }
            ?>
            <div class="ecf7l-notice ecf7l-notice-success">
                <div class="ecf7l-notice-icon">
                    <svg viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                              d="M16.707 5.293a1 1 0 010 1.414l-7.25 7.25a1 1 0 01-1.414 0l-3.5-3.5a1 1 0 011.414-1.414L8.5 11.086l6.543-6.543a1 1 0 011.414 0z"
                              clip-rule="evenodd"/>
                    </svg>
                </div>
                <div><p><?php printf( esc_html__( 'Se han borrado %d leads.', 'easycf7-leads' ), (int) $deleted ); ?></p></div>
            </div>
            <?php
        } elseif ( 'assign' === $bulk_action ) {

            if ( ! $is_pro ) :
                ?>
                <div class="ecf7l-notice ecf7l-notice-error">
                    <div class="ecf7l-notice-icon">
                        <svg viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd"
                                  d="M10 18a8 8 0 100-16 8 8 0 000 16zm-.75-10.5a.75.75 0 011.5 0v4a.75.75 0 11-1.5 0v-4zM10 14a1 1 0 100 2 1 1 0 000-2z"
                                  clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <div><p><?php esc_html_e( 'La asignación masiva de leads solo está disponible en la versión PRO.', 'easycf7-leads' ); ?></p></div>
                </div>
                <?php
            else :
                $user_id = isset( $_POST['bulk_assign_user'] ) ? (int) $_POST['bulk_assign_user'] : 0;
                if ( ! $user_id ) :
                    ?>
                    <div class="ecf7l-notice ecf7l-notice-error">
                        <div class="ecf7l-notice-icon">
                            <svg viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd"
                                      d="M10 18a8 8 0 100-16 8 8 0 000 16zm-.75-10.5a.75.75 0 011.5 0v4a.75.75 0 11-1.5 0v-4zM10 14a1 1 0 100 2 1 1 0 000-2z"
                                      clip-rule="evenodd"/>
                            </svg>
                        </div>
                        <div><p><?php esc_html_e( 'Selecciona un usuario para la asignación masiva.', 'easycf7-leads' ); ?></p></div>
                    </div>
                    <?php
                else :
                    $new_assigned_user = get_user_by( 'id', $user_id );
                    if ( ! $new_assigned_user ) :
                        ?>
                        <div class="ecf7l-notice ecf7l-notice-error">
                            <div class="ecf7l-notice-icon">
                                <svg viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd"
                                          d="M10 18a8 8 0 100-16 8 8 0 000 16zm-.75-10.5a.75.75 0 011.5 0v4a.75.75 0 11-1.5 0v-4zM10 14a1 1 0 100 2 1 1 0 000-2z"
                                          clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <div><p><?php esc_html_e( 'El usuario seleccionado no existe.', 'easycf7-leads' ); ?></p></div>
                        </div>
                        <?php
                    else :
                        $assigned_name = $new_assigned_user->display_name;
                        $current_user  = wp_get_current_user();
                        $by_name       = $current_user ? $current_user->display_name : __( 'Alguien', 'easycf7-leads' );

                        $notified = 0;
                        $updated  = 0;

                        $settings = get_option( 'ecf7l_settings', array() );
                        $notify   = ! empty( $settings['notify_assignee_email'] );

                        foreach ( $ids as $lead_id ) {
                            $lead = ECF7L_Leads::get( $lead_id );
                            if ( ! $lead ) {
                                continue;
                            }

                            ECF7L_Leads::update(
                                $lead_id,
                                array(
                                    'assigned_to' => $user_id,
                                )
                            );
                            $updated++;

                            if ( class_exists( 'ECF7L_Notes' ) ) {
                                $msg = sprintf(
                                    '%s asignó el lead a %s (acción masiva)',
                                    $by_name,
                                    $assigned_name
                                );
                                ECF7L_Notes::add( $lead_id, $msg, 'event', $current_user ? $current_user->ID : 0 );
                            }

                            if ( $notify && ! empty( $new_assigned_user->user_email ) ) {
                                $lead_link = add_query_arg(
                                    array(
                                        'page'    => 'easycf7-leads',
                                        'view'    => 'detail',
                                        'lead_id' => $lead_id,
                                    ),
                                    admin_url( 'admin.php' )
                                );

                                $subject = sprintf(
                                    __( 'Se te ha asignado un nuevo lead: %s', 'easycf7-leads' ),
                                    $lead['form_title']
                                );

                                $body_lines   = array();
                                $body_lines[] = sprintf(
                                    __( 'Hola %s,', 'easycf7-leads' ),
                                    $assigned_name ? $assigned_name : $new_assigned_user->user_login
                                );
                                $body_lines[] = '';
                                $body_lines[] = __( 'Se te ha asignado un nuevo lead en EasyCF7 Leads (asignación masiva).', 'easycf7-leads' );
                                $body_lines[] = '';
                                $body_lines[] = sprintf( __( 'Formulario: %s', 'easycf7-leads' ), $lead['form_title'] );
                                $body_lines[] = sprintf( __( 'Nombre: %s', 'easycf7-leads' ), $lead['name'] );
                                $body_lines[] = sprintf( __( 'Email: %s', 'easycf7-leads' ), $lead['email'] );
                                if ( ! empty( $lead['phone'] ) ) {
                                    $body_lines[] = sprintf( __( 'Teléfono: %s', 'easycf7-leads' ), $lead['phone'] );
                                }
                                $body_lines[] = '';
                                $body_lines[] = __( 'Puedes ver el detalle del lead aquí:', 'easycf7-leads' );
                                $body_lines[] = $lead_link;
                                $body_lines[] = '';
                                $body_lines[] = get_bloginfo( 'name' );

                                $body    = implode( '<br>', $body_lines );
                                $headers = array( 'Content-Type: text/html; charset=UTF-8' );

                                if (
                                    wp_mail(
                                        $new_assigned_user->user_email,
                                        $subject,
                                        '<div style="font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif;font-size:14px;color:#0f172a;line-height:1.5;"><div style="border-radius:12px;padding:16px 18px;background:linear-gradient(135deg,#2de3a7,#2d6df6);color:#f9fafb;margin-bottom:16px;font-weight:600;">EasyCF7 Leads PRO</div><div>' . $body . '</div><div style="margin-top:16px;font-size:12px;color:#6b7280;">Enviado desde EasyCF7 Leads PRO.</div></div>',
                                        $headers
                                    )
                                ) {
                                    $notified++;
                                }
                            }
                        }
                        ?>
                        <div class="ecf7l-notice ecf7l-notice-success">
                            <div class="ecf7l-notice-icon">
                                <svg viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd"
                                          d="M16.707 5.293a1 1 0 010 1.414l-7.25 7.25a1 1 0 01-1.414 0l-3.5-3.5a1 1 0 011.414-1.414L8.5 11.086l6.543-6.543a1 1 0 011.414 0z"
                                          clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <div>
                                <p>
                                <?php
                                printf(
                                    esc_html__( 'Leads actualizados: %1$d. Notificaciones enviadas: %2$d.', 'easycf7-leads' ),
                                    (int) $updated,
                                    (int) $notified
                                );
                                ?>
                                </p>
                            </div>
                        </div>
                        <?php
                    endif;
                endif;
            endif;
        }
    endif;
}

// --- Filtros (GET) ---
$paged    = isset( $_GET['paged'] ) ? max( 1, (int) $_GET['paged'] ) : 1;
$per_page = 20;

$search  = isset( $_GET['s'] ) ? sanitize_text_field( wp_unslash( $_GET['s'] ) ) : '';
$status  = isset( $_GET['status'] ) ? sanitize_text_field( wp_unslash( $_GET['status'] ) ) : '';
$form_id = isset( $_GET['form_id'] ) ? (int) $_GET['form_id'] : 0;

$date_from = isset( $_GET['date_from'] ) ? sanitize_text_field( wp_unslash( $_GET['date_from'] ) ) : '';
$date_to   = isset( $_GET['date_to'] ) ? sanitize_text_field( wp_unslash( $_GET['date_to'] ) ) : '';

$assigned_to_raw     = isset( $_GET['assigned_to'] ) ? wp_unslash( $_GET['assigned_to'] ) : '';
$assigned_to         = ( '' !== $assigned_to_raw ) ? $assigned_to_raw : '';
$unassigned_only     = isset( $_GET['unassigned_only'] ) && '1' === $_GET['unassigned_only'];
$unassigned_only_eff = $is_pro ? $unassigned_only : false;

$orderby = isset( $_GET['orderby'] ) ? sanitize_text_field( wp_unslash( $_GET['orderby'] ) ) : 'date';
$order   = isset( $_GET['order'] ) ? strtolower( sanitize_text_field( wp_unslash( $_GET['order'] ) ) ) : 'desc';
$order   = ( 'asc' === $order ) ? 'asc' : 'desc';

$statuses = ECF7L_Leads::get_statuses();

// Formularios CF7
$cf7_forms = get_posts(
    array(
        'post_type'      => 'wpcf7_contact_form',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
    )
);

$args = array(
    'paged'           => $paged,
    'per_page'        => $per_page,
    'search'          => $search,
    'status'          => $status,
    'form_id'         => $form_id,
    'date_from'       => $date_from,
    'date_to'         => $date_to,
    'assigned_to'     => $assigned_to,
    'unassigned_only' => $unassigned_only_eff ? 1 : 0,
    'orderby'         => $orderby,
    'order'           => $order,
);



// Listado normal en pantalla
$results     = ECF7L_Leads::get_all( $args );
$items       = $results['items'];
$total       = $results['total'];
$total_pages = max( 1, ceil( $total / $per_page ) );

// Mapa de usuarios por ID (para mostrar responsable)
$user_map = array();
foreach ( $users as $u ) {
    $user_map[ $u->ID ] = $u->display_name;
}

// Para enlaces de ordenación y export
$base_url  = admin_url( 'admin.php?page=easycf7-leads' );
$base_args = array(
    's'               => $search,
    'status'          => $status,
    'form_id'         => $form_id ?: '',
    'date_from'       => $date_from,
    'date_to'         => $date_to,
    'assigned_to'     => $assigned_to,
    'unassigned_only' => $unassigned_only_eff ? '1' : '',
);

// URL de exportación CSV vía admin-ajax (respeta filtros actuales)
$export_args = array_merge(
    $base_args,
    array(
        'orderby'      => $orderby,
        'order'        => $order,
        'action'       => 'ecf7l_export_leads',
    )
);

$export_url = add_query_arg( $export_args, admin_url( 'admin-ajax.php' ) );

if ( ! function_exists( 'ecf7l_sortable_th' ) ) {
    function ecf7l_sortable_th( $key, $label, $current_orderby, $current_order, $base_url, $base_args ) {
        $next_order = 'asc';
        if ( $current_orderby === $key && 'asc' === $current_order ) {
            $next_order = 'desc';
        }
        $url = add_query_arg(
            array_merge(
                $base_args,
                array(
                    'orderby' => $key,
                    'order'   => $next_order,
                    'paged'   => 1,
                )
            ),
            $base_url
        );
        $class = '';
        if ( $current_orderby === $key ) {
            $class = 'sorted ' . $current_order;
        } else {
            $class = 'sortable';
        }

        echo '<th scope="col" class="' . esc_attr( $class ) . '">';
        echo '<a href="' . esc_url( $url ) . '"><span>' . esc_html( $label ) . '</span></a>';
        echo '</th>';
    }
}
?>
<div class="wrap ecf7l-wrap">
    <div class="ecf7l-header">
        <div class="ecf7l-header-main">
        <div class="ecf7l-logo-badge">
            <?php
                echo '<img src="' . plugins_url( 'assets/images/icon-300x300-trasparent.png', dirname(__FILE__) ) . '" > ';
            ?>
        </div>
            <div>
                <h1 class="ecf7l-header-title">Leads</h1>
                <p class="ecf7l-header-subtitle">Resumen de actividad de tus formularios de Contact Form 7.</p>
            </div>
        </div>
        <div class="ecf7l-header-side">
            <div class="ecf7l-badge-pill">
                <span class="dot"></span>
                <span><?php echo ecf7l_is_pro() ? 'Licencia PRO activa' : 'Modo FREE'; ?></span>
            </div>
        </div>
    </div>

    <form method="get" class="ecf7l-filters">
        <input type="hidden" name="page" value="easycf7-leads">
        <div class="ecf7l-filter-field">
            <label for="ecf7l-search"><?php esc_html_e( 'Buscar', 'easycf7-leads' ); ?></label>
            <input type="search" id="ecf7l-search" name="s" value="<?php echo esc_attr( $search ); ?>" placeholder="<?php esc_attr_e( 'Nombre, email o teléfono', 'easycf7-leads' ); ?>">
        </div>

        <div class="ecf7l-filter-field">
            <label for="ecf7l-status"><?php esc_html_e( 'Estado', 'easycf7-leads' ); ?></label>
            <select name="status" id="ecf7l-status">
                <option value=""><?php esc_html_e( 'Todos', 'easycf7-leads' ); ?></option>
                <?php foreach ( $statuses as $key => $label ) : ?>
                    <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $status, $key ); ?>>
                        <?php echo esc_html( $label ); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="ecf7l-filter-field">
            <label for="ecf7l-form-id"><?php esc_html_e( 'Formulario', 'easycf7-leads' ); ?></label>
            <select name="form_id" id="ecf7l-form-id">
                <option value="0"><?php esc_html_e( 'Todos', 'easycf7-leads' ); ?></option>
                <?php foreach ( $cf7_forms as $form ) : ?>
                    <option value="<?php echo (int) $form->ID; ?>" <?php selected( $form_id, $form->ID ); ?>>
                        <?php echo esc_html( $form->post_title ); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="ecf7l-filter-field">
            <label for="ecf7l-date-from"><?php esc_html_e( 'Desde', 'easycf7-leads' ); ?></label>
            <input type="date" id="ecf7l-date-from" name="date_from" value="<?php echo esc_attr( $date_from ); ?>">
        </div>

        <div class="ecf7l-filter-field">
            <label for="ecf7l-date-to"><?php esc_html_e( 'Hasta', 'easycf7-leads' ); ?></label>
            <input type="date" id="ecf7l-date-to" name="date_to" value="<?php echo esc_attr( $date_to ); ?>">
        </div>

        <div class="ecf7l-filter-field">
            <label for="ecf7l-assigned-to"><?php esc_html_e( 'Responsable', 'easycf7-leads' ); ?></label>
            <select name="assigned_to" id="ecf7l-assigned-to">
                <option value=""><?php esc_html_e( 'Todos', 'easycf7-leads' ); ?></option>
                <option value="0" <?php selected( '0', $assigned_to ); ?>>
                    <?php esc_html_e( 'Sin asignar', 'easycf7-leads' ); ?>
                </option>
                <?php foreach ( $users as $user ) : ?>
                    <option value="<?php echo (int) $user->ID; ?>" <?php selected( (string) $user->ID, (string) $assigned_to ); ?>>
                        <?php echo esc_html( $user->display_name ); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="ecf7l-filter-field">
            <label>&nbsp;</label>
            <label>
                <input type="checkbox" name="unassigned_only" value="1"
                    <?php checked( $unassigned_only ); ?>
                    <?php disabled( ! $is_pro ); ?>
                >
                <?php esc_html_e( 'Solo sin asignar (PRO)', 'easycf7-leads' ); ?>
            </label>
        </div>

        <div class="ecf7l-filter-field">
            <label>&nbsp;</label>
            <button class="button button-secondary" type="submit"><?php esc_html_e( 'Filtrar', 'easycf7-leads' ); ?></button>
        </div>
    </form>

    <form method="post">
        <?php wp_nonce_field( 'ecf7l_leads_bulk' ); ?>

        <div class="ecf7l-bulk-actions">
            <select name="ecf7l_bulk_action" id="ecf7l-bulk-action">
                <option value=""><?php esc_html_e( 'Acciones en lote', 'easycf7-leads' ); ?></option>
                <option value="delete"><?php esc_html_e( 'Borrar seleccionados', 'easycf7-leads' ); ?></option>
                <option value="assign" <?php disabled( ! $is_pro ); ?>>
                    <?php esc_html_e( 'Asignar a usuario (PRO)', 'easycf7-leads' ); ?>
                </option>
            </select>

            <span id="ecf7l-bulk-assign-user-wrap" style="display:none;">
                <select name="bulk_assign_user">
                    <option value=""><?php esc_html_e( 'Selecciona usuario', 'easycf7-leads' ); ?></option>
                    <?php foreach ( $users as $user ) : ?>
                        <option value="<?php echo (int) $user->ID; ?>">
                            <?php echo esc_html( $user->display_name ); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </span>

            <button type="submit" class="button action"><?php esc_html_e( 'Aplicar', 'easycf7-leads' ); ?></button>

            <a href="<?php echo esc_url( $export_url ); ?>" class="button button-secondary" style="margin-left:auto;">
                <?php esc_html_e( 'Exportar CSV (Excel)', 'easycf7-leads' ); ?>
            </a>

        </div>

        <table class="widefat fixed striped ecf7l-table">
            <thead>
                <tr>
                    <th class="check-column">
                        <input type="checkbox" id="ecf7l-select-all">
                    </th>
                    <?php
                    ecf7l_sortable_th( 'id', 'ID', $orderby, $order, $base_url, $base_args );
                    ecf7l_sortable_th( 'form', 'Formulario', $orderby, $order, $base_url, $base_args );
                    ecf7l_sortable_th( 'name', 'Nombre', $orderby, $order, $base_url, $base_args );
                    ecf7l_sortable_th( 'email', 'Email', $orderby, $order, $base_url, $base_args );
                    ecf7l_sortable_th( 'phone', 'Teléfono', $orderby, $order, $base_url, $base_args );
                    ecf7l_sortable_th( 'status', 'Estado', $orderby, $order, $base_url, $base_args );
                    ?>
                    <th><?php esc_html_e( 'Etiquetas', 'easycf7-leads' ); ?></th>
                    <th><?php esc_html_e( 'Responsable', 'easycf7-leads' ); ?></th>
                    <?php
                    ecf7l_sortable_th( 'date', 'Fecha', $orderby, $order, $base_url, $base_args );
                    ?>
                    <th><?php esc_html_e( 'Acciones', 'easycf7-leads' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if ( empty( $items ) ) : ?>
                    <tr><td colspan="10"><?php esc_html_e( 'No se han encontrado leads.', 'easycf7-leads' ); ?></td></tr>
                <?php else : ?>
                    <?php foreach ( $items as $lead ) : ?>
                        <?php
                        $lead_id      = (int) $lead['id'];
                        $status_key   = $lead['status'] ? $lead['status'] : 'nuevo';
                        $status_label = isset( $statuses[ $status_key ] ) ? $statuses[ $status_key ] : $status_key;
                        $tags_str     = trim( (string) $lead['tags'] );
                        $tags_arr     = array();
                        if ( '' !== $tags_str ) {
                            $tags_arr = array_map( 'trim', explode( ',', $tags_str ) );
                        }

                        $assigned_to_id   = (int) $lead['assigned_to'];
                        $assigned_to_name = $assigned_to_id && isset( $user_map[ $assigned_to_id ] ) ? $user_map[ $assigned_to_id ] : '';
                        ?>
                        <tr>
                            <th class="check-column">
                                <input type="checkbox" name="lead_ids[]" value="<?php echo $lead_id; ?>" class="ecf7l-lead-checkbox">
                            </th>
                            <td>
                                <a href="<?php echo esc_url( admin_url( 'admin.php?page=easycf7-leads&view=detail&lead_id=' . $lead_id ) ); ?>">
                                    #<?php echo $lead_id; ?>
                                </a>
                            </td>
                            <td><?php echo esc_html( $lead['form_title'] ); ?></td>
                            <td><?php echo esc_html( $lead['name'] ); ?></td>
                            <td>
                                <?php if ( $lead['email'] ) : ?>
                                    <a href="mailto:<?php echo esc_attr( $lead['email'] ); ?>"><?php echo esc_html( $lead['email'] ); ?></a>
                                <?php endif; ?>
                            </td>
                            <td><?php echo esc_html( $lead['phone'] ); ?></td>
                            <td>
                                <span class="ecf7l-status-badge ecf7l-status-<?php echo esc_attr( $status_key ); ?>">
                                    <?php echo esc_html( $status_label ); ?>
                                </span>
                            </td>
                            <td>
                                <?php if ( ! empty( $tags_arr ) ) : ?>
                                    <span class="ecf7l-tags">
                                        <?php foreach ( $tags_arr as $tag ) : ?>
                                            <span class="tag">#<?php echo esc_html( $tag ); ?></span>
                                        <?php endforeach; ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php
                                if ( $assigned_to_name ) {
                                    echo esc_html( $assigned_to_name );
                                } else {
                                    echo '—';
                                }
                                ?>
                            </td>
                            <td><?php echo esc_html( $lead['submitted_at'] ); ?></td>
                            <td>
                                <a class="button button-small" href="<?php echo esc_url( admin_url( 'admin.php?page=easycf7-leads&view=detail&lead_id=' . $lead_id ) ); ?>">
                                    <?php esc_html_e( 'Ver', 'easycf7-leads' ); ?>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>

        <?php
        if ( $total_pages > 1 ) :
            $page_links = paginate_links(
                array(
                    'base'      => add_query_arg( array_merge( $base_args, array( 'paged' => '%#%', 'orderby' => $orderby, 'order' => $order ) ), $base_url ),
                    'format'    => '',
                    'prev_text' => '&laquo;',
                    'next_text' => '&raquo;',
                    'total'     => $total_pages,
                    'current'   => $paged,
                )
            );
            ?>
            <div class="tablenav">
                <div class="tablenav-pages">
                    <?php echo wp_kses_post( $page_links ); ?>
                </div>
            </div>
        <?php endif; ?>
    </form>
</div>


<?php include ECF7L_DIR . 'views/footer.php';  ?>