<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$lead_id = isset( $_GET['lead_id'] ) ? (int) $_GET['lead_id'] : 0;
$lead    = ECF7L_Leads::get( $lead_id );
$is_pro  = ecf7l_is_pro();

if ( ! $lead ) :
    ?>
    <div class="wrap ecf7l-wrap">
        <h1>Lead no encontrado</h1>
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=easycf7-leads' ) ); ?>" class="button">← Volver al listado</a>
    </div>
    <?php
    return;
endif;

// Guardar notas / estado / etiquetas / asignado
if ( isset( $_POST['ecf7l_save_lead'] ) && check_admin_referer( 'ecf7l_save_lead_' . $lead_id ) ) {

    // Guardamos valores anteriores para comparar
    $old_lead = $lead;

    $new_status = isset( $_POST['status'] ) ? sanitize_text_field( wp_unslash( $_POST['status'] ) ) : '';
    $new_tags   = isset( $_POST['tags'] ) ? sanitize_text_field( wp_unslash( $_POST['tags'] ) ) : '';
    $new_notes  = isset( $_POST['notes'] ) ? wp_kses_post( wp_unslash( $_POST['notes'] ) ) : '';

    $update = array(
        'status' => $new_status,
        'tags'   => $new_tags,
        'notes'  => $new_notes,
    );

    $new_assigned_to = 0;
    if ( $is_pro ) {
        $new_assigned_to = isset( $_POST['assigned_to'] ) ? (int) $_POST['assigned_to'] : 0;
        $update['assigned_to'] = $new_assigned_to;
    }

    ECF7L_Leads::update( $lead_id, $update );
    $lead = ECF7L_Leads::get( $lead_id );

    // Registrar cambios en el timeline
    if ( class_exists( 'ECF7L_Notes' ) ) {

        $user_id   = get_current_user_id();
        $user_name = '';
        if ( $user_id ) {
            $u = get_user_by( 'id', $user_id );
            if ( $u ) {
                $user_name = $u->display_name;
            }
        }

        // 1) Cambio de estado
        $old_status = $old_lead['status'] ? $old_lead['status'] : 'nuevo';
        $statuses   = ECF7L_Leads::get_statuses();
        $old_label  = isset( $statuses[ $old_status ] ) ? $statuses[ $old_status ] : $old_status;
        $new_label  = isset( $statuses[ $new_status ] ) ? $statuses[ $new_status ] : $new_status;

        if ( $new_status && $new_status !== $old_lead['status'] ) {
            $msg = sprintf(
                '%s cambió el estado: %s → %s',
                $user_name ? $user_name : __( 'Alguien', 'easycf7-leads' ),
                $old_label,
                $new_label
            );
            ECF7L_Notes::add( $lead_id, $msg, 'event', $user_id );
        }

        // 2) Cambio de etiquetas
        $old_tags = trim( (string) $old_lead['tags'] );
        if ( $new_tags !== $old_tags ) {
            $msg = sprintf(
                '%s actualizó las etiquetas: "%s" → "%s"',
                $user_name ? $user_name : __( 'Alguien', 'easycf7-leads' ),
                $old_tags,
                $new_tags
            );
            ECF7L_Notes::add( $lead_id, $msg, 'event', $user_id );
        }

        // 3) Cambio de responsable (solo PRO)
        if ( $is_pro ) {
            $old_assigned_to = (int) $old_lead['assigned_to'];

            if ( $new_assigned_to !== $old_assigned_to ) {

                $old_assigned_name = '';
                if ( $old_assigned_to ) {
                    $u_old = get_user_by( 'id', $old_assigned_to );
                    if ( $u_old ) {
                        $old_assigned_name = $u_old->display_name;
                    }
                }

                $new_assigned_name = '';
                $new_assigned_user = null;
                if ( $new_assigned_to ) {
                    $new_assigned_user = get_user_by( 'id', $new_assigned_to );
                    if ( $new_assigned_user ) {
                        $new_assigned_name = $new_assigned_user->display_name;
                    }
                }

                if ( $new_assigned_to && ! $old_assigned_to ) {
                    // Asignado por primera vez
                    $msg = sprintf(
                        '%s asignó el lead a %s',
                        $user_name ? $user_name : __( 'Alguien', 'easycf7-leads' ),
                        $new_assigned_name
                    );
                } elseif ( ! $new_assigned_to && $old_assigned_to ) {
                    // Se ha quitado responsable
                    $msg = sprintf(
                        '%s quitó la asignación (antes: %s)',
                        $user_name ? $user_name : __( 'Alguien', 'easycf7-leads' ),
                        $old_assigned_name
                    );
                } else {
                    // Cambio de una persona a otra
                    $msg = sprintf(
                        '%s cambió el responsable: %s → %s',
                        $user_name ? $user_name : __( 'Alguien', 'easycf7-leads' ),
                        $old_assigned_name,
                        $new_assigned_name
                    );
                }

                ECF7L_Notes::add( $lead_id, $msg, 'event', $user_id );

                // Enviar email al nuevo responsable si:
                // - hay nuevo responsable
                // - la opción está activa
                // - hay usuario con email
                $settings = get_option( 'ecf7l_settings', array() );
                $notify   = ! empty( $settings['notify_assignee_email'] );

                if ( $notify && $new_assigned_user && ! empty( $new_assigned_user->user_email ) && $new_assigned_to ) {

                    $lead_link = add_query_arg(
                        array(
                            'page'    => 'easycf7-leads',
                            'view'    => 'detail',
                            'lead_id' => $lead_id,
                        ),
                        admin_url( 'admin.php' )
                    );

                    $subject = sprintf(
                        __( 'Se te ha asignado un nuevo lead: %s', 'easycf7-leads' ),
                        $lead['form_title']
                    );

                    $body_lines = array();

                    $body_lines[] = sprintf(
                        __( 'Hola %s,', 'easycf7-leads' ),
                        $new_assigned_name ? $new_assigned_name : $new_assigned_user->user_login
                    );
                    $body_lines[] = '';
                    $body_lines[] = __( 'Se te ha asignado un nuevo lead en EasyCF7 Leads.', 'easycf7-leads' );
                    $body_lines[] = '';
                    $body_lines[] = sprintf( __( 'Formulario: %s', 'easycf7-leads' ), $lead['form_title'] );
                    $body_lines[] = sprintf( __( 'Nombre: %s', 'easycf7-leads' ), $lead['name'] );
                    $body_lines[] = sprintf( __( 'Email: %s', 'easycf7-leads' ), $lead['email'] );
                    if ( ! empty( $lead['phone'] ) ) {
                        $body_lines[] = sprintf( __( 'Teléfono: %s', 'easycf7-leads' ), $lead['phone'] );
                    }
                    $body_lines[] = '';
                    $body_lines[] = __( 'Puedes ver el detalle del lead aquí:', 'easycf7-leads' );
                    $body_lines[] = $lead_link;
                    $body_lines[] = '';
                    $body_lines[] = get_bloginfo( 'name' );

                    $body    = implode( "<br>", $body_lines );
                    $headers = array( 'Content-Type: text/html; charset=UTF-8' );
                    
                    @wp_mail(
                        $new_assigned_user->user_email,
                        $subject,
                        '<div style="font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif;font-size:14px;color:#0f172a;line-height:1.5;"><div style="border-radius:12px;padding:16px 18px;background:linear-gradient(135deg,#2de3a7,#2d6df6);color:#f9fafb;margin-bottom:16px;font-weight:600;">EasyCF7 Leads PRO</div><div>' . $body . '</div><div style="margin-top:16px;font-size:12px;color:#6b7280;">Enviado desde EasyCF7 Leads PRO.</div></div>',
                        $headers
                    );
                    
                }
            }
        }
    
    }

    echo '<div class="ecf7l-notice ecf7l-notice-success">
        <div class="ecf7l-notice-icon">
            <!-- Success icon -->
            <svg viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" 
                    d="M16.707 5.293a1 1 0 010 1.414l-7.25 7.25a1 1 0 01-1.414 0l-3.5-3.5a1 1 0 011.414-1.414L8.5 11.086l6.543-6.543a1 1 0 011.414 0z" 
                    clip-rule="evenodd"/>
            </svg>
        </div>
        <div>Lead actualizado.</div>
    </div>';
    }

// Añadir nueva nota al timeline
if ( isset( $_POST['ecf7l_add_note'] ) && check_admin_referer( 'ecf7l_add_note_' . $lead_id ) ) {
    $msg = isset( $_POST['timeline_note'] ) ? wp_kses_post( wp_unslash( $_POST['timeline_note'] ) ) : '';

    if ( '' !== trim( $msg ) && class_exists( 'ECF7L_Notes' ) ) {
        ECF7L_Notes::add( $lead_id, $msg, 'note', get_current_user_id() );
        echo '<div class="ecf7l-notice ecf7l-notice-success">
            <div class="ecf7l-notice-icon">
                <!-- Success icon -->
                <svg viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" 
                        d="M16.707 5.293a1 1 0 010 1.414l-7.25 7.25a1 1 0 01-1.414 0l-3.5-3.5a1 1 0 011.414-1.414L8.5 11.086l6.543-6.543a1 1 0 011.414 0z" 
                        clip-rule="evenodd"/>
                </svg>
            </div>
            <div>Nota añadida al Timeline.</div>
        </div>';
    }
}


$data     = ! empty( $lead['data'] ) ? maybe_unserialize( $lead['data'] ) : array();
$statuses = ECF7L_Leads::get_statuses();
$users    = get_users( array( 'role__in' => array( 'administrator', 'editor' ) ) );
$timeline = class_exists( 'ECF7L_Notes' ) ? ECF7L_Notes::get_for_lead( $lead_id ) : array();

// Información de User Agent (sistema operativo / dispositivo)
$ua_raw  = ! empty( $lead['user_agent'] ) ? (string) $lead['user_agent'] : '';
$ua_info = array(
    'os'     => '',
    'device' => '',
);

if ( $ua_raw ) {
    $ua_lower = strtolower( $ua_raw );

    $os = '';
    if ( false !== strpos( $ua_raw, 'Windows' ) ) {
        $os = 'Windows';
    } elseif ( false !== strpos( $ua_raw, 'Macintosh' ) || false !== strpos( $ua_raw, 'Mac OS' ) ) {
        $os = 'macOS';
    } elseif ( false !== strpos( $ua_raw, 'Android' ) ) {
        $os = 'Android';
    } elseif ( false !== strpos( $ua_raw, 'iPhone' ) || false !== strpos( $ua_raw, 'iPad' ) ) {
        $os = 'iOS';
    } elseif ( false !== strpos( $ua_raw, 'Linux' ) ) {
        $os = 'Linux';
    }

    $device = 'Escritorio';
    if ( false !== strpos( $ua_lower, 'mobile' ) || false !== strpos( $ua_lower, 'mobi' ) || false !== strpos( $ua_lower, 'iphone' ) || false !== strpos( $ua_lower, 'android' ) ) {
        $device = 'Móvil';
    }
    if ( false !== strpos( $ua_lower, 'tablet' ) || false !== strpos( $ua_lower, 'ipad' ) ) {
        $device = 'Tablet';
    }

    $ua_info['os']     = $os;
    $ua_info['device'] = $device;
}

// GeoIP (solo PRO)
$geo = false;
if ( $is_pro && ! empty( $lead['ip_address'] ) && class_exists( 'ECF7L_GeoIP' ) ) {
    $geo = ECF7L_GeoIP::lookup( $lead['ip_address'] );
}

?>

<div class="wrap ecf7l-wrap">
<div class="ecf7l-header">
    <div class="ecf7l-header-main">
        <div class="ecf7l-logo-badge">
            <?php
                echo '<img src="' . plugins_url( 'assets/images/icon-300x300-trasparent.png', dirname(__FILE__) ) . '" > ';
            ?>
        </div>
        <div>
            <h1 class="ecf7l-header-title">Lead #<?php echo (int) $lead['id']; ?></h1>
            <p class="ecf7l-header-subtitle">EasyCF7 Leads</p>
        </div>
    </div>
    <div class="ecf7l-header-side">
        <div class="ecf7l-badge-pill">
            <span class="dot"></span>
            <span><?php echo ecf7l_is_pro() ? 'Licencia PRO activa' : 'Modo FREE'; ?></span>
        </div>
    </div>
</div>

    <a href="<?php echo esc_url( admin_url( 'admin.php?page=easycf7-leads' ) ); ?>" class="button">← Volver al listado</a>

    <div class="ecf7l-lead-columns">
        <div class="ecf7l-lead-main">
            <h2>Datos básicos</h2>
            <table class="form-table">
                <tr>
                    <th>Formulario</th>
                    <td><?php echo esc_html( $lead['form_title'] ); ?></td>
                </tr>
                <tr>
                    <th>Nombre</th>
                    <td><?php echo esc_html( $lead['name'] ); ?></td>
                </tr>
                <tr>
                    <th>Email</th>
                    <td><?php echo esc_html( $lead['email'] ); ?></td>
                </tr>
                <tr>
                    <th>Teléfono</th>
                    <td><?php echo esc_html( $lead['phone'] ); ?></td>
                </tr>
                <tr>
                    <th>Fecha</th>
                    <td><?php echo esc_html( $lead['submitted_at'] ); ?></td>
                </tr>
                <tr>
                    <th>IP</th>
                    <td>
                        <?php echo esc_html( $lead['ip_address'] ); ?>
                        <?php if ( $is_pro ) : ?>
                            <?php if ( $geo ) : ?>
                                <div class="ecf7l-geoip-info">
                                    <p><strong>Localización aproximada:</strong></p>
                                    <ul>
                                        <?php if ( ! empty( $geo['country'] ) ) : ?>
                                            <li><strong>País:</strong> <?php echo esc_html( $geo['country'] ); ?></li>
                                        <?php endif; ?>
                                        <?php if ( ! empty( $geo['region'] ) ) : ?>
                                            <li><strong>Región:</strong> <?php echo esc_html( $geo['region'] ); ?></li>
                                        <?php endif; ?>
                                        <?php if ( ! empty( $geo['city'] ) ) : ?>
                                            <li><strong>Ciudad:</strong> <?php echo esc_html( $geo['city'] ); ?></li>
                                        <?php endif; ?>
                                        <?php if ( ! empty( $geo['isp'] ) ) : ?>
                                            <li><strong>ISP:</strong> <?php echo esc_html( $geo['isp'] ); ?></li>
                                        <?php endif; ?>
                                        <?php if ( ! empty( $geo['timezone'] ) ) : ?>
                                            <li><strong>Zona horaria:</strong> <?php echo esc_html( $geo['timezone'] ); ?></li>
                                        <?php endif; ?>
                                    </ul>
                                    <?php if ( ! empty( $geo['lat'] ) && ! empty( $geo['lon'] ) ) : ?>
                                        <?php
                                        $lat        = $geo['lat'];
                                        $lon        = $geo['lon'];
                                        $bbox_delta = 0.05;
                                        $min_lon    = $lon - $bbox_delta;
                                        $max_lon    = $lon + $bbox_delta;
                                        $min_lat    = $lat - $bbox_delta;
                                        $max_lat    = $lat + $bbox_delta;
                                        $osm_src    = sprintf(
                                            'https://www.openstreetmap.org/export/embed.html?bbox=%s,%s,%s,%s&layer=mapnik&marker=%s,%s',
                                            rawurlencode( $min_lon ),
                                            rawurlencode( $min_lat ),
                                            rawurlencode( $max_lon ),
                                            rawurlencode( $max_lat ),
                                            rawurlencode( $lat ),
                                            rawurlencode( $lon )
                                        );
                                        ?>
                                        <div class="ecf7l-geoip-map">
                                            <iframe
                                                width="100%"
                                                height="220"
                                                frameborder="0"
                                                scrolling="no"
                                                marginheight="0"
                                                marginwidth="0"
                                                src="<?php echo esc_url( $osm_src ); ?>">
                                            </iframe>
                                            <small>
                                                <a href="<?php echo esc_url( 'https://www.openstreetmap.org/?mlat=' . $lat . '&mlon=' . $lon . '#map=12/' . $lat . '/' . $lon ); ?>" target="_blank" rel="noopener noreferrer">
                                                    Ver en OpenStreetMap
                                                </a>
                                            </small>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php else : ?>
                                <p class="description">No se pudo obtener localización para esta IP.</p>
                            <?php endif; ?>
                        <?php else : ?>
                            <p class="description">La geolocalización de IP está disponible en la versión PRO.</p>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th>Dispositivo</th>
                    <td>
                        <?php if ( $ua_raw ) : ?>
                            <?php if ( ! empty( $ua_info['os'] ) || ! empty( $ua_info['device'] ) ) : ?>
                                <strong><?php echo esc_html( trim( $ua_info['os'] . ' · ' . $ua_info['device'] ) ); ?></strong><br>
                            <?php endif; ?>
                            <code style="white-space: pre-wrap;"><?php echo esc_html( $ua_raw ); ?></code>
                        <?php else : ?>
                            &mdash;
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th>Fuente</th>
                    <td><?php echo esc_html( $lead['source'] ); ?></td>
                </tr>
            </table>

            <h2>Datos enviados</h2>
            <table class="widefat fixed striped">
                <thead>
                    <tr>
                        <th>Campo</th>
                        <th>Valor</th>
                    </tr>
                </thead>
                <tbody>
                <?php if ( empty( $data ) ) : ?>
                    <tr><td colspan="2">Sin datos.</td></tr>
                <?php else : ?>
                    <?php foreach ( $data as $key => $value ) : ?>
                        <tr>
                            <td><?php echo esc_html( $key ); ?></td>
                            <td><?php echo is_array( $value ) ? esc_html( implode( ', ', $value ) ) : esc_html( $value ); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                </tbody>
            </table>

            <h2>Timeline</h2>

            <div class="ecf7l-timeline">
                <?php if ( empty( $timeline ) ) : ?>
                    <p>No hay eventos todavía.</p>
                <?php else : ?>
                    <ul>
                        <?php foreach ( $timeline as $item ) : ?>
                            <li>
                                <div><strong><?php echo esc_html( $item['created_at'] ); ?></strong></div>
                                <?php
                                $user_name = '';
                                if ( ! empty( $item['created_by'] ) ) {
                                    $u = get_user_by( 'id', (int) $item['created_by'] );
                                    if ( $u ) {
                                        $user_name = $u->display_name;
                                    }
                                }
                                if ( $user_name ) :
                                ?>
                                    <div><em><?php echo esc_html( $user_name ); ?></em></div>
                                <?php endif; ?>
                                <div><?php echo wpautop( esc_html( $item['message'] ) ); ?></div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>

            <h3>Añadir nota al timeline</h3>
            <form method="post">
                <?php wp_nonce_field( 'ecf7l_add_note_' . $lead_id ); ?>
                <textarea name="timeline_note" rows="4" class="large-text" placeholder="Ej: Llamada al cliente, comentario interno, seguimiento..."></textarea>
                <p class="submit">
                    <button type="submit" name="ecf7l_add_note" class="button">Añadir nota</button>
                </p>
            </form>
        </div>

        <div class="ecf7l-lead-sidebar">

            <h2>Gestión del lead</h2>
            <form method="post">
                <?php wp_nonce_field( 'ecf7l_save_lead_' . $lead_id ); ?>
                <table class="form-table">
                    <tr>
                        <th><label for="ecf7l-status">Estado</label></th>
                        <td>
                            <select name="status" id="ecf7l-status">
                                <?php foreach ( $statuses as $key => $label ) : ?>
                                    <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $lead['status'] ? $lead['status'] : 'nuevo', $key ); ?>>
                                        <?php echo esc_html( $label ); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="ecf7l-tags">Etiquetas</label></th>
                        <td>
                            <input type="text" name="tags" id="ecf7l-tags" class="regular-text" value="<?php echo esc_attr( $lead['tags'] ); ?>" placeholder="ej: google ads, boda, vip">
                            <p class="description">Separadas por comas.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="ecf7l-assigned-to">Responsable</label></th>
                        <td>
                            <?php if ( $is_pro ) : ?>
                                <select name="assigned_to" id="ecf7l-assigned-to">
                                    <option value="0">Sin asignar</option>
                                    <?php foreach ( $users as $user ) : ?>
                                        <option value="<?php echo (int) $user->ID; ?>" <?php selected( (int) $lead['assigned_to'], $user->ID ); ?>>
                                            <?php echo esc_html( $user->display_name ); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            <?php else : ?>
                                <span class="ecf7l-pro-only">Disponible en PRO</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="ecf7l-notes">Notas internas</label></th>
                        <td>
                            <textarea name="notes" id="ecf7l-notes" rows="6" class="large-text"><?php echo esc_textarea( $lead['notes'] ); ?></textarea>
                        </td>
                    </tr>
                </table>
                <p class="submit">
                    <button type="submit" name="ecf7l_save_lead" class="button button-primary">Guardar cambios</button>
                </p>
            </form>

            <div class="ecf7l-box-pro">
                <h3>Tips de uso</h3>
                <ul>
                    <li>Usa estados para seguir tu embudo de ventas.</li>
                    <li>Usa etiquetas para campañas: <code>#google-ads</code>, <code>#facebook</code>, etc.</li>
                    <li>Asignar responsable te ayuda a repartir trabajo (PRO).</li>
                </ul>
            </div>
        </div>
    </div>
</div>


<?php include ECF7L_DIR . 'views/footer.php';  ?>