<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$is_pro = ecf7l_is_pro();

// Filtro por formulario (dashboard)
$selected_form_id = isset( $_GET['ecf7l_form_id'] ) ? (int) $_GET['ecf7l_form_id'] : 0;

$cf7_forms = get_posts(
    array(
        'post_type'      => 'wpcf7_contact_form',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
    )
);

$stats = ECF7L_Leads::get_stats_overview( $selected_form_id );
$last_days = ECF7L_Leads::get_leads_by_day( 7, $selected_form_id );
$max_daily = 0;
foreach ( $last_days as $row ) {
    if ( $row['total'] > $max_daily ) {
        $max_daily = $row['total'];
    }
}
$kpis = ECF7L_Leads::get_conversion_kpis( $selected_form_id );

// Mis leads (solo PRO)
$my_leads = array();
$statuses = array();
if ( $is_pro && is_user_logged_in() ) {
    $current_user = wp_get_current_user();
    if ( $current_user && $current_user->ID ) {
        $my_args = array(
            'paged'           => 1,
            'per_page'        => 10,
            'assigned_to'     => $current_user->ID,
            'unassigned_only' => 0,
            'orderby'         => 'date',
            'order'           => 'desc',
        );
        $my_res   = ECF7L_Leads::get_all( $my_args );
        $my_leads = $my_res['items'];
        $statuses = ECF7L_Leads::get_statuses();
    }
}
?>

<div class="wrap ecf7l-wrap">
    <div class="ecf7l-header">
        <div class="ecf7l-header-main">
            <div class="ecf7l-logo-badge">
                <?php
                    echo '<img src="' . plugins_url( 'assets/images/icon-300x300-trasparent.png', dirname(__FILE__) ) . '" > ';
                ?>
            </div>
            <div>
                <h1 class="ecf7l-header-title">EasyCF7 Leads</h1>
                <p class="ecf7l-header-subtitle">Resumen de actividad de tus formularios de Contact Form 7.</p>
            </div>
        </div>
        <div class="ecf7l-header-side">
            <div class="ecf7l-badge-pill">
                <span class="dot"></span>
                <span><?php echo $is_pro ? 'Licencia PRO activa' : 'Modo FREE'; ?></span>
            </div>
            <div class="ecf7l-light-label"><?php echo date_i18n( 'd M Y' ); ?></div>
        </div>
    </div>


    <form method="get" class="ecf7l-dashboard-filters">
        <input type="hidden" name="page" value="easycf7-leads-dashboard">
        <label for="ecf7l-form-filter">Formulario:</label>
        <select name="ecf7l_form_id" id="ecf7l-form-filter" onchange="this.form.submit()">
            <option value="0"><?php esc_html_e( 'Todos los formularios', 'easycf7-leads' ); ?></option>
            <?php foreach ( $cf7_forms as $form ) : ?>
                <option value="<?php echo (int) $form->ID; ?>" <?php selected( $selected_form_id, $form->ID ); ?>>
                    <?php echo esc_html( $form->post_title ); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <?php if ( $selected_form_id ) : ?>
            <span class="ecf7l-dashboard-filter-note">
                Mostrando datos solo de este formulario.
            </span>
        <?php endif; ?>
    </form>

    <div class="ecf7l-dashboard-cards">
        <div class="ecf7l-card">
            <h3>Total de leads</h3>
            <div class="ecf7l-value"><?php echo (int) $stats['total']; ?></div>
            <small><?php echo $selected_form_id ? 'Formulario seleccionado' : 'Todos los formularios'; ?></small>
        </div>
        <div class="ecf7l-card">
            <h3>Últimos 7 días</h3>
            <div class="ecf7l-value"><?php echo (int) $stats['last7']; ?></div>
            <small>Leads recientes</small>
        </div>
        <div class="ecf7l-card">
            <h3>Tasa de ganados</h3>
            <div class="ecf7l-value">
                <?php
                if ( $kpis['total'] > 0 && $kpis['won'] > 0 ) {
                    echo esc_html( number_format_i18n( $kpis['win_rate'], 1 ) ) . '%';
                } else {
                    echo '—';
                }
                ?>
            </div>
            <small>
                <?php
                if ( $kpis['total'] > 0 ) {
                    printf(
                        'Ganados: %d de %d',
                        (int) $kpis['won'],
                        (int) $kpis['total']
                    );
                } else {
                    echo 'Sin leads suficientes.';
                }
                ?>
            </small>
        </div>
        <div class="ecf7l-card">
            <h3>Tiempo medio hasta ganado</h3>
            <div class="ecf7l-value">
                <?php
                if ( $kpis['won'] > 0 && null !== $kpis['avg_days_to_win'] ) {
                    if ( $kpis['avg_days_to_win'] < 1 ) {
                        echo '&lt; 1 día';
                    } else {
                        echo esc_html( number_format_i18n( $kpis['avg_days_to_win'], 1 ) ) . ' días';
                    }
                } else {
                    echo '—';
                }
                ?>
            </div>
            <small>
                <?php
                if ( $kpis['won'] > 0 ) {
                    echo 'Basado en leads con estado "Ganado".';
                } else {
                    echo 'Todavía no hay leads ganados.';
                }
                ?>
            </small>
        </div>
        <div class="ecf7l-card">
            <h3>Licencia</h3>
            <?php
                if ( $is_pro ) :
            ?>
                <p class="ecf7l-license-status-valid">Licencia PRO activa.</p>
            <?php else : ?>
                <p class="ecf7l-license-status-free">Estás en modo FREE.</p>
                <p>Desbloquea asignaciones, exportaciones ilimitadas, webhooks, Google Sheets (vía Apps Script) y más. Recibe soporte y actualizaciones.</p>
                <a href="admin.php/?billing_cycle=annual&page=easycf7-leads-dashboard-pricing" class="button button-primary ecf7l-btn-upgrade">Activar</a>
            <?php endif; ?>
        </div>
    </div>

    <h2 style="margin-top:30px;">Actividad últimos 7 días</h2>

    <?php if ( empty( $last_days ) ) : ?>
        <p>Todavía no hay datos suficientes para mostrar actividad diaria.</p>
    <?php else : ?>
        <div class="ecf7l-bar-chart">
            <?php foreach ( $last_days as $row ) : ?>
                <?php
                $value      = (int) $row['total'];
                $height     = $max_daily > 0 ? round( ( $value / $max_daily ) * 100 ) : 0;
                $label_date = date_i18n( 'd/m', strtotime( $row['date'] ) );
                ?>
                <div class="ecf7l-bar">
                    <div class="ecf7l-bar-inner" style="height: <?php echo $height; ?>%;">
                        <?php if ( $value > 0 ) : ?>
                            <span class="ecf7l-bar-value"><?php echo $value; ?></span>
                        <?php endif; ?>
                    </div>
                    <span class="ecf7l-bar-label"><?php echo esc_html( $label_date ); ?></span>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <h2 style="margin-top:30px;">Embudo de estados</h2>

    <?php if ( empty( $stats['total'] ) ) : ?>
        <p>No hay leads suficientes para mostrar el embudo.</p>
    <?php else : ?>
        <div class="ecf7l-funnel">
            <?php
            $total_leads = (int) $stats['total'];
            foreach ( $stats['by_status'] as $key => $row ) :
                $count      = (int) $row['count'];
                $percent    = $total_leads > 0 ? round( ( $count / $total_leads ) * 100 ) : 0;
                $bar_width  = $percent > 0 ? max( 8, $percent ) : 8; // mínimo visual
                ?>
                <div class="ecf7l-funnel-row">
                    <div class="ecf7l-funnel-label">
                        <span class="ecf7l-status-badge ecf7l-status-<?php echo esc_attr( $key ); ?>">
                            <?php echo esc_html( $row['label'] ); ?>
                        </span>
                    </div>
                    <div class="ecf7l-funnel-bar-wrap">
                        <div class="ecf7l-funnel-bar ecf7l-status-<?php echo esc_attr( $key ); ?>"
                             style="width: <?php echo $bar_width; ?>%;"></div>
                    </div>
                    <div class="ecf7l-funnel-count">
                        <?php echo $count; ?> (<?php echo $percent; ?>%)
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    
    <?php if ( $is_pro ) : ?>
        <h2 style="margin-top:30px;">Mis leads asignados</h2>
        <?php if ( is_user_logged_in() && ! empty( $my_leads ) ) : ?>
            <table class="widefat fixed striped ecf7l-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'ID', 'easycf7-leads' ); ?></th>
                        <th><?php esc_html_e( 'Formulario', 'easycf7-leads' ); ?></th>
                        <th><?php esc_html_e( 'Nombre', 'easycf7-leads' ); ?></th>
                        <th><?php esc_html_e( 'Email', 'easycf7-leads' ); ?></th>
                        <th><?php esc_html_e( 'Teléfono', 'easycf7-leads' ); ?></th>
                        <th><?php esc_html_e( 'Estado', 'easycf7-leads' ); ?></th>
                        <th><?php esc_html_e( 'Fecha', 'easycf7-leads' ); ?></th>
                        <th><?php esc_html_e( 'Acciones', 'easycf7-leads' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ( $my_leads as $lead ) : ?>
                        <?php
                        $lead_id    = (int) $lead['id'];
                        $status_key = $lead['status'] ? $lead['status'] : 'nuevo';
                        $status_lbl = isset( $statuses[ $status_key ] ) ? $statuses[ $status_key ] : $status_key;
                        ?>
                        <tr>
                            
                            <td><a href="admin.php?page=easycf7-leads&view=detail&lead_id=<?php echo esc_html( $lead['id'] ); ?>">#<?php echo esc_html( $lead['id'] ); ?></a></td>
                            
                            <td><?php echo esc_html( $lead['form_title'] ); ?></td>
                            <td><?php echo esc_html( $lead['name'] ); ?></td>
                            <td>
                                <?php if ( $lead['email'] ) : ?>
                                    <a href="mailto:<?php echo esc_attr( $lead['email'] ); ?>"><?php echo esc_html( $lead['email'] ); ?></a>
                                <?php endif; ?>
                            </td>
                            <td><?php echo esc_html( $lead['phone'] ); ?></td>
                            <td>
                                <span class="ecf7l-status-badge ecf7l-status-<?php echo esc_attr( $status_key ); ?>">
                                    <?php echo esc_html( $status_lbl ); ?>
                                </span>
                            </td>
                            <td><?php echo esc_html( $lead['submitted_at'] ); ?></td>
                            <td>
                                <a class="button button-small" href="<?php echo esc_url( admin_url( 'admin.php?page=easycf7-leads&view=detail&lead_id=' . $lead_id ) ); ?>">
                                    <?php esc_html_e( 'Ver', 'easycf7-leads' ); ?>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <p class="description">Mostrando hasta 10 últimos leads asignados. Para ver todos, usa la página de Leads con filtros.</p>
        <?php elseif ( is_user_logged_in() ) : ?>
            <p>No tienes leads asignados todavía.</p>
        <?php else : ?>
            <p>Inicia sesión para ver tus leads asignados.</p>
        <?php endif; ?>
    <?php endif; ?>

<h2 style="margin-top:30px;">Top formularios</h2>
    <table class="widefat fixed striped ecf7l-table">
        <thead>
        <tr>
            <th>Formulario</th>
            <th>Leads</th>
        </tr>
        </thead>
        <tbody>
        <?php if ( empty( $stats['top_forms'] ) ) : ?>
            <tr><td colspan="2">Todavía no hay datos.</td></tr>
        <?php else : ?>
            <?php foreach ( $stats['top_forms'] as $row ) : ?>
                <tr>
                    <td><?php echo esc_html( $row['form_title'] ); ?></td>
                    <td><?php echo (int) $row['total']; ?></td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include ECF7L_DIR . 'views/footer.php';  ?>
