<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class ECF7L_Webhooks {

    public static function get_webhooks() {
        $settings = get_option( 'ecf7l_settings', array() );
        return isset( $settings['webhooks'] ) && is_array( $settings['webhooks'] ) ? $settings['webhooks'] : array();
    }

    public static function send_lead( $lead_id ) {
        $webhooks = self::get_webhooks();
        if ( empty( $webhooks ) ) {
            return;
        }

        $lead = ECF7L_Leads::get( $lead_id );
        if ( ! $lead ) {
            return;
        }

        $data = array(
            'id'          => (int) $lead['id'],
            'form_id'     => (int) $lead['form_id'],
            'form_title'  => $lead['form_title'],
            'submitted_at'=> $lead['submitted_at'],
            'name'        => $lead['name'],
            'email'       => $lead['email'],
            'phone'       => $lead['phone'],
            'status'      => $lead['status'],
            'tags'        => $lead['tags'],
            'source'      => $lead['source'],
            'assigned_to' => (int) $lead['assigned_to'],
            'ip_address'  => $lead['ip_address'],
            'user_agent'  => $lead['user_agent'],
            'data'        => maybe_unserialize( $lead['data'] ),
        );

        foreach ( $webhooks as $hook ) {
            if ( empty( $hook['url'] ) || empty( $hook['active'] ) ) {
                continue;
            }

            // Filtrado por formulario
            if ( ! empty( $hook['forms'] ) && is_array( $hook['forms'] ) ) {
                if ( ! in_array( (int) $lead['form_id'], array_map( 'intval', $hook['forms'] ), true ) ) {
                    continue;
                }
            }

            $url = esc_url_raw( $hook['url'] );

            $response = wp_remote_post(
                $url,
                array(
                    'timeout' => 5,
                    'headers' => array(
                        'Content-Type' => 'application/json; charset=utf-8',
                    ),
                    'body'    => wp_json_encode( $data ),
                )
            );

            // Registrar en timeline (si existe la clase de notas)
            if ( class_exists( 'ECF7L_Notes' ) ) {

                if ( is_wp_error( $response ) ) {
                    $msg = sprintf(
                        'Error al enviar lead al webhook: %s (%s)',
                        $url,
                        $response->get_error_message()
                    );
                    ECF7L_Notes::add( $lead_id, $msg, 'event', 0 );

                } else {
                    $code = wp_remote_retrieve_response_code( $response );
                    $msg  = sprintf(
                        'Lead enviado al webhook: %s (HTTP %d)',
                        $url,
                        $code ? $code : 0
                    );
                    ECF7L_Notes::add( $lead_id, $msg, 'event', 0 );
                }
            }
        }
    }

}
