<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class ECF7L_Notes {

    public static function table() {
        global $wpdb;
        return $wpdb->prefix . 'ecf7l_lead_notes';
    }

    public static function add( $lead_id, $message, $type = 'note', $user_id = 0 ) {
        global $wpdb;

        $lead_id = (int) $lead_id;
        if ( $lead_id <= 0 || '' === trim( $message ) ) {
            return false;
        }

        if ( ! $user_id ) {
            $user_id = get_current_user_id();
        }

        return $wpdb->insert(
            self::table(),
            array(
                'lead_id'    => $lead_id,
                'type'       => sanitize_text_field( $type ),
                'message'    => wp_kses_post( $message ),
                'created_by' => $user_id ? (int) $user_id : null,
                'created_at' => current_time( 'mysql' ),
            ),
            array(
                '%d',
                '%s',
                '%s',
                '%d',
                '%s',
            )
        );
    }

    public static function get_for_lead( $lead_id ) {
        global $wpdb;
        $lead_id = (int) $lead_id;
        if ( $lead_id <= 0 ) {
            return array();
        }

        $table = self::table();

        return $wpdb->get_results(
            $wpdb->prepare(
                "SELECT * FROM $table WHERE lead_id = %d ORDER BY created_at DESC, id DESC",
                $lead_id
            ),
            ARRAY_A
        );
    }

    /**
     * Atajo para eventos automáticos del sistema.
     */
    public static function log_event( $lead_id, $message ) {
        return self::add( $lead_id, $message, 'event', 0 );
    }

    /**
     * Borra todas las notas de un lead concreto.
     */
    public static function delete_for_lead( $lead_id ) {
        global $wpdb;
        $lead_id = (int) $lead_id;
        if ( $lead_id <= 0 ) {
            return false;
        }

        return $wpdb->delete(
            self::table(),
            array( 'lead_id' => $lead_id ),
            array( '%d' )
        );
    }
}
