<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Geolocalización simple de IP usando ip-api.com (sin clave).
 * Solo se usa en el admin (detalle de lead) y se cachea con transients.
 */
class ECF7L_GeoIP {

    /**
     * @param string $ip
     * @return array|false
     */
    public static function lookup( $ip ) {
        $ip = trim( (string) $ip );
        if ( '' === $ip ) {
            return false;
        }

        if ( filter_var( $ip, FILTER_VALIDATE_IP ) === false ) {
            return false;
        }

        $cache_key = 'ecf7l_geo_' . md5( $ip );
        $cached    = get_transient( $cache_key );
        if ( false !== $cached ) {
            return $cached;
        }

        $url = 'http://ip-api.com/json/' . rawurlencode( $ip ) . '?fields=status,message,country,regionName,city,lat,lon,isp,org,timezone,query';

        $response = wp_remote_get( $url );

        if ( is_wp_error( $response ) ) {
            set_transient( $cache_key, false, HOUR_IN_SECONDS );
            return false;
        }

        $code = wp_remote_retrieve_response_code( $response );
        if ( 200 !== (int) $code ) {
            set_transient( $cache_key, false, HOUR_IN_SECONDS );
            return false;
        }

        $body = wp_remote_retrieve_body( $response );
        $data = json_decode( $body, true );
        if ( ! is_array( $data ) || empty( $data['status'] ) || 'success' !== $data['status'] ) {
            set_transient( $cache_key, false, HOUR_IN_SECONDS );
            return false;
        }

        $result = array(
            'ip'       => isset( $data['query'] ) ? $data['query'] : $ip,
            'country'  => isset( $data['country'] ) ? $data['country'] : '',
            'region'   => isset( $data['regionName'] ) ? $data['regionName'] : '',
            'city'     => isset( $data['city'] ) ? $data['city'] : '',
            'lat'      => isset( $data['lat'] ) ? (float) $data['lat'] : 0,
            'lon'      => isset( $data['lon'] ) ? (float) $data['lon'] : 0,
            'isp'      => isset( $data['isp'] ) ? $data['isp'] : '',
            'org'      => isset( $data['org'] ) ? $data['org'] : '',
            'timezone' => isset( $data['timezone'] ) ? $data['timezone'] : '',
        );

        set_transient( $cache_key, $result, DAY_IN_SECONDS );

        return $result;
    }
}
