<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class ECF7L_Exporter {

    public static function maybe_export() {
        if ( ! is_admin() ) {
            return;
        }

        if ( ! isset( $_GET['ecf7l_export'] ) || $_GET['ecf7l_export'] !== 'csv' ) {
            return;
        }

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        check_admin_referer( 'ecf7l_export_csv' );

        $is_pro = ecf7l_is_pro();

        $args = array(
            'paged'    => 1,
            'per_page' => $is_pro ? 100000 : 100, // Free limitado a 100
        );

        if ( ! empty( $_GET['status'] ) ) {
            $args['status'] = sanitize_text_field( wp_unslash( $_GET['status'] ) );
        }
        if ( ! empty( $_GET['form_id'] ) ) {
            $args['form_id'] = (int) $_GET['form_id'];
        }

        $result = ECF7L_Leads::get_all( $args );
        $items  = $result['items'];

        header( 'Content-Type: text/csv; charset=utf-8' );
        header( 'Content-Disposition: attachment; filename=easycf7-leads-' . date( 'Ymd-His' ) . '.csv' );

        $output = fopen( 'php://output', 'w' );

        $headers = array(
            'ID',
            'Formulario',
            'Fecha',
            'Nombre',
            'Email',
            'Teléfono',
            'Estado',
            'Etiquetas',
            'Fuente',
            'IP',
        );

        if ( $is_pro ) {
            $headers[] = 'Asignado a';
        }

        fputcsv( $output, $headers );

        foreach ( $items as $lead ) {
            $row = array(
                $lead['id'],
                $lead['form_title'],
                $lead['submitted_at'],
                $lead['name'],
                $lead['email'],
                $lead['phone'],
                $lead['status'],
                $lead['tags'],
                $lead['source'],
                $lead['ip_address'],
            );

            if ( $is_pro ) {
                $assigned = '';
                if ( $lead['assigned_to'] ) {
                    $user = get_user_by( 'id', (int) $lead['assigned_to'] );
                    if ( $user ) {
                        $assigned = $user->display_name;
                    }
                }
                $row[] = $assigned;
            }

            fputcsv( $output, $row );
        }

        fclose( $output );
        exit;
    }
}

add_action( 'admin_init', array( 'ECF7L_Exporter', 'maybe_export' ) );
