(function () {
    if (typeof ECF7L_WhatsApp === 'undefined') {
        return;
    }

    var enabled = parseInt(ECF7L_WhatsApp.enabled || 0, 10);
    var formsConfig = ECF7L_WhatsApp.forms || {};

    if (!enabled) {
        return;
    }

    document.addEventListener('wpcf7mailsent', function (event) {
        try {
            var formId = event.detail.contactFormId;
            var config = formsConfig[formId];

            if (!config || !config.enabled) {
                return;
            }

            var number = config.number || '';
            if (!number) {
                return;
            }

            var template = config.template || '';

            if (event.detail.inputs && event.detail.inputs.length) {
                event.detail.inputs.forEach(function (input) {
                    var tag = '[' + input.name + ']';
                    var value = input.value || '';
                    template = template.split(tag).join(value);
                });
            }

            var url = 'https://wa.me/' + encodeURIComponent(number) + '?text=' + encodeURIComponent(template);
            window.location.href = url;
        } catch (e) {
            // silent
        }
    }, false);
})();
